/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.data.gen;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import tv.mapper.mapperbase.MapperBase;
import tv.mapper.mapperbase.world.level.block.CustomDoorBlock;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = (Set)Stream.of(Blocks.f_50260_, Blocks.f_50273_, Blocks.f_50569_, Blocks.f_50310_, Blocks.f_50312_, Blocks.f_50316_, Blocks.f_50314_, Blocks.f_50318_, Blocks.f_50320_, Blocks.f_50456_, Blocks.f_50525_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50466_, Blocks.f_50464_, Blocks.f_50523_, Blocks.f_50460_, Blocks.f_50465_, Blocks.f_50462_, Blocks.f_50459_, Blocks.f_50458_, Blocks.f_50463_, Blocks.f_50520_, Blocks.f_50524_, Blocks.f_50457_, Blocks.f_50461_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected static <T> T withExplosionDecay(ItemLike p_218552_0_, FunctionUserBuilder<T> p_218552_1_) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(p_218552_0_.m_5456_()) ? p_218552_1_.m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : p_218552_1_.m_5476_());
    }

    protected static <T> T withSurvivesExplosion(ItemLike p_218560_0_, ConditionUserBuilder<T> p_218560_1_) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(p_218560_0_.m_5456_()) ? p_218560_1_.m_6509_(ExplosionCondition.m_81661_()) : p_218560_1_.m_5476_());
    }

    protected LootTable.Builder createStandardTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSlabTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withExplosionDecay((ItemLike)block, LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createDoorTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)CustomDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)))).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createBedTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD)))).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createChestTable(String name, Block block) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY))).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Block loot) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_6509_(SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withSurvivesExplosion((ItemLike)block, LootItem.m_79579_((ItemLike)loot))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Item loot) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_6509_(SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withSurvivesExplosion((ItemLike)block, LootItem.m_79579_((ItemLike)loot))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Item loot, int min, int max, int fortune) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_6509_(SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)BaseLootTableProvider.withSurvivesExplosion((ItemLike)block, LootItem.m_79579_((ItemLike)loot).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)fortune)))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    public void m_6865_(HashCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().m_60589_(), entry.getValue().m_79165_(LootContextParamSets.f_81421_).m_79167_());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(HashCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.m_123916_();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                MapperBase.LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "MapperBase LootTables";
    }
}

